



global DataPath= "D:\课程专题\1.城市劳动经济学\Labor-2025\Data"



use  "$DataPath\CH09\data_Mig.dta",clear

gen ratio_income= 收入_外出/收入_本地
gen ratio_out= 农民工_外出/农民工_本地
gen ratio_bet= 农民工_外出_跨省/农民工_外出_省内
gen ratio_family= 农民工_举家/农民工_外出*100

gen year=年份


replace 农民工_总数=农民工_总数/10000
replace 农民工_外出_省内=农民工_外出_省内/10000
replace 农民工_外出_跨省=农民工_外出_跨省/10000



twoway ///
(connected 农民工_外出_省内 year if year>=2009 & year<=2020, msize(med) msymbol(Oh) mcolor(gs6) lp(solid)  lwidth(medthin) lcolor(gs6)) ///
(connected 农民工_外出_跨省 year if year>=2009 & year<=2020, msize(medlarge) msymbol(th) mcolor(gs6) lp(solid)  lwidth(medthin) lcolor(gs6)) ///
,scheme(s1color)  graphregion(color(white))   ///
xmtick(2009(1)2020)  xlabel(2009(1)2020, angle(0) labsize(small))  ///
ymtick(0.7(0.1)1)  ylabel(0.7(0.1)1, angle(360) labsize(small))  ///
xline(2014, lcolor(gs6) lp(shortdash) lwidth(thin)) ///
yline(0.7867, lcolor(gs6) lp(shortdash) lwidth(thin)) ///
xtitle("年份", size(small))  ///
ytitle("单位：亿", size(small))  ///
legend(order( 1 "省内" 2 "跨省") row(1) size(small)) 


graph export "$DataPath\CH09\图9_4_农民工流动_省内VS跨省.png", replace width(1600)
